// UltraLight.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "UltraLight.h"
#include "Share.h"
#include "RFID.h"
//#include <winsock2.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern SOCKET			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;

/////////////////////////////////////////////////////////////////////////////
// CUltraLight dialog


CUltraLight::CUltraLight(CWnd* pParent /*=NULL*/)
	: CDialog(CUltraLight::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUltraLight)
	m_intULIdle = 0;
	m_strULMSG = _T("");
	m_strRdPage21 = _T("");
	m_strRdPage22 = _T("");
	m_strRdPage3 = _T("");
	m_strWrPage21 = _T("");
	m_strWrPage22 = _T("");
	m_strWrPage3 = _T("");
	m_strRdPage0 = _T("");
	m_strRdPage1 = _T("");
	m_strRdPage10 = _T("");
	m_strRdPage11 = _T("");
	m_strRdPage12 = _T("");
	m_strRdPage13 = _T("");
	m_strRdPage14 = _T("");
	m_strRdPage15 = _T("");
	m_strRdPage4 = _T("");
	m_strRdPage5 = _T("");
	m_strRdPage6 = _T("");
	m_strRdPage7 = _T("");
	m_strRdPage8 = _T("");
	m_strRdPage9 = _T("");
	m_strWrPage0 = _T("");
	m_strWrPage1 = _T("");
	m_strWrPage10 = _T("");
	m_strWrPage11 = _T("");
	m_strWrPage12 = _T("");
	m_strWrPage13 = _T("");
	m_strWrPage14 = _T("");
	m_strWrPage15 = _T("");
	m_strWrPage4 = _T("");
	m_strWrPage5 = _T("");
	m_strWrPage6 = _T("");
	m_strWrPage7 = _T("");
	m_strWrPage8 = _T("");
	m_strWrPage9 = _T("");
	m_strRetULMSG = _T("");
	//}}AFX_DATA_INIT
}


void CUltraLight::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUltraLight)
	DDX_Control(pDX, IDC_COMBOWritePage, m_ctlWritePage);
	DDX_Control(pDX, IDC_COMBOReadPage, m_ctlReadPage);
	DDX_Control(pDX, IDC_BUTTONWritePage, m_btnWritePage);
	DDX_Control(pDX, IDC_BUTTONRequst, m_bntRequst);
	DDX_Control(pDX, IDC_BUTTONReadPage, m_btnReadPage);
	DDX_Control(pDX, IDC_BUTTONHalt, m_btnHalt);
	DDX_Radio(pDX, IDC_RADIOIdle, m_intULIdle);
	DDX_Text(pDX, IDC_EDITULMSG, m_strULMSG);
	DDX_Text(pDX, IDC_Edit_RdPage21, m_strRdPage21);
	DDV_MaxChars(pDX, m_strRdPage21, 6);
	DDX_Text(pDX, IDC_Edit_RdPage22, m_strRdPage22);
	DDV_MaxChars(pDX, m_strRdPage22, 6);
	DDX_Text(pDX, IDC_Edit_RdPage3, m_strRdPage3);
	DDV_MaxChars(pDX, m_strRdPage3, 12);
	DDX_Text(pDX, IDC_Edit_WrPage21, m_strWrPage21);
	DDV_MaxChars(pDX, m_strWrPage21, 5);
	DDX_Text(pDX, IDC_Edit_WrPage22, m_strWrPage22);
	DDV_MaxChars(pDX, m_strWrPage22, 5);
	DDX_Text(pDX, IDC_Edit_WrPage3, m_strWrPage3);
	DDV_MaxChars(pDX, m_strWrPage3, 12);
	DDX_Text(pDX, IDC_EDITRdPage0, m_strRdPage0);
	DDV_MaxChars(pDX, m_strRdPage0, 12);
	DDX_Text(pDX, IDC_EDITRdPage1, m_strRdPage1);
	DDV_MaxChars(pDX, m_strRdPage1, 12);
	DDX_Text(pDX, IDC_EDITRdPage10, m_strRdPage10);
	DDV_MaxChars(pDX, m_strRdPage10, 12);
	DDX_Text(pDX, IDC_EDITRdPage11, m_strRdPage11);
	DDV_MaxChars(pDX, m_strRdPage11, 12);
	DDX_Text(pDX, IDC_EDITRdPage12, m_strRdPage12);
	DDV_MaxChars(pDX, m_strRdPage12, 12);
	DDX_Text(pDX, IDC_EDITRdPage13, m_strRdPage13);
	DDV_MaxChars(pDX, m_strRdPage13, 12);
	DDX_Text(pDX, IDC_EDITRdPage14, m_strRdPage14);
	DDV_MaxChars(pDX, m_strRdPage14, 12);
	DDX_Text(pDX, IDC_EDITRdPage15, m_strRdPage15);
	DDV_MaxChars(pDX, m_strRdPage15, 12);
	DDX_Text(pDX, IDC_EDITRdPage4, m_strRdPage4);
	DDV_MaxChars(pDX, m_strRdPage4, 12);
	DDX_Text(pDX, IDC_EDITRdPage5, m_strRdPage5);
	DDV_MaxChars(pDX, m_strRdPage5, 12);
	DDX_Text(pDX, IDC_EDITRdPage6, m_strRdPage6);
	DDV_MaxChars(pDX, m_strRdPage6, 12);
	DDX_Text(pDX, IDC_EDITRdPage7, m_strRdPage7);
	DDV_MaxChars(pDX, m_strRdPage7, 12);
	DDX_Text(pDX, IDC_EDITRdPage8, m_strRdPage8);
	DDV_MaxChars(pDX, m_strRdPage8, 12);
	DDX_Text(pDX, IDC_EDITRdPage9, m_strRdPage9);
	DDV_MaxChars(pDX, m_strRdPage9, 12);
	DDX_Text(pDX, IDC_EDITWrPage0, m_strWrPage0);
	DDV_MaxChars(pDX, m_strWrPage0, 11);
	DDX_Text(pDX, IDC_EDITWrPage1, m_strWrPage1);
	DDV_MaxChars(pDX, m_strWrPage1, 11);
	DDX_Text(pDX, IDC_EDITWrPage10, m_strWrPage10);
	DDV_MaxChars(pDX, m_strWrPage10, 11);
	DDX_Text(pDX, IDC_EDITWrPage11, m_strWrPage11);
	DDV_MaxChars(pDX, m_strWrPage11, 11);
	DDX_Text(pDX, IDC_EDITWrPage12, m_strWrPage12);
	DDV_MaxChars(pDX, m_strWrPage12, 11);
	DDX_Text(pDX, IDC_EDITWrPage13, m_strWrPage13);
	DDV_MaxChars(pDX, m_strWrPage13, 11);
	DDX_Text(pDX, IDC_EDITWrPage14, m_strWrPage14);
	DDV_MaxChars(pDX, m_strWrPage14, 11);
	DDX_Text(pDX, IDC_EDITWrPage15, m_strWrPage15);
	DDV_MaxChars(pDX, m_strWrPage15, 11);
	DDX_Text(pDX, IDC_EDITWrPage4, m_strWrPage4);
	DDV_MaxChars(pDX, m_strWrPage4, 11);
	DDX_Text(pDX, IDC_EDITWrPage5, m_strWrPage5);
	DDV_MaxChars(pDX, m_strWrPage5, 11);
	DDX_Text(pDX, IDC_EDITWrPage6, m_strWrPage6);
	DDV_MaxChars(pDX, m_strWrPage6, 11);
	DDX_Text(pDX, IDC_EDITWrPage7, m_strWrPage7);
	DDV_MaxChars(pDX, m_strWrPage7, 11);
	DDX_Text(pDX, IDC_EDITWrPage8, m_strWrPage8);
	DDV_MaxChars(pDX, m_strWrPage8, 11);
	DDX_Text(pDX, IDC_EDITWrPage9, m_strWrPage9);
	DDV_MaxChars(pDX, m_strWrPage9, 11);
	DDX_Text(pDX, IDC_EDITRetULMSG, m_strRetULMSG);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUltraLight, CDialog)
	//{{AFX_MSG_MAP(CUltraLight)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTONRequst, OnBUTTONRequst)
	ON_BN_CLICKED(IDC_BUTTONHalt, OnBUTTONHalt)
	ON_BN_CLICKED(IDC_BUTTONReadPage, OnBUTTONReadPage)
	ON_BN_CLICKED(IDC_BUTTONWritePage, OnBUTTONWritePage)
	ON_EN_CHANGE(IDC_EDITRdPage0, OnChangeEDITRdPage0)
	ON_EN_CHANGE(IDC_EDITRdPage1, OnChangeEDITRdPage1)
	ON_EN_CHANGE(IDC_Edit_RdPage21, OnChangeEditRdPage21)
	ON_EN_CHANGE(IDC_Edit_RdPage22, OnChangeEditRdPage22)
	ON_EN_CHANGE(IDC_Edit_RdPage3, OnChangeEditRdPage3)
	ON_EN_CHANGE(IDC_EDITRdPage4, OnChangeEDITRdPage4)
	ON_EN_CHANGE(IDC_EDITRdPage5, OnChangeEDITRdPage5)
	ON_EN_CHANGE(IDC_EDITRdPage6, OnChangeEDITRdPage6)
	ON_EN_CHANGE(IDC_EDITRdPage7, OnChangeEDITRdPage7)
	ON_EN_CHANGE(IDC_EDITRdPage8, OnChangeEDITRdPage8)
	ON_EN_CHANGE(IDC_EDITRdPage9, OnChangeEDITRdPage9)
	ON_EN_CHANGE(IDC_EDITRdPage10, OnChangeEDITRdPage10)
	ON_EN_CHANGE(IDC_EDITRdPage11, OnChangeEDITRdPage11)
	ON_EN_CHANGE(IDC_EDITRdPage12, OnChangeEDITRdPage12)
	ON_EN_CHANGE(IDC_EDITRdPage13, OnChangeEDITRdPage13)
	ON_EN_CHANGE(IDC_EDITRdPage14, OnChangeEDITRdPage14)
	ON_EN_CHANGE(IDC_EDITRdPage15, OnChangeEDITRdPage15)
	ON_EN_CHANGE(IDC_EDITWrPage0, OnChangeEDITWrPage0)
	ON_EN_CHANGE(IDC_EDITWrPage1, OnChangeEDITWrPage1)
	ON_EN_CHANGE(IDC_Edit_WrPage21, OnChangeEditWrPage21)
	ON_EN_CHANGE(IDC_Edit_WrPage22, OnChangeEditWrPage22)
	ON_EN_CHANGE(IDC_Edit_WrPage3, OnChangeEditWrPage3)
	ON_EN_CHANGE(IDC_EDITWrPage4, OnChangeEDITWrPage4)
	ON_EN_CHANGE(IDC_EDITWrPage5, OnChangeEDITWrPage5)
	ON_EN_CHANGE(IDC_EDITWrPage6, OnChangeEDITWrPage6)
	ON_EN_CHANGE(IDC_EDITWrPage7, OnChangeEDITWrPage7)
	ON_EN_CHANGE(IDC_EDITWrPage8, OnChangeEDITWrPage8)
	ON_EN_CHANGE(IDC_EDITWrPage9, OnChangeEDITWrPage9)
	ON_EN_CHANGE(IDC_EDITWrPage10, OnChangeEDITWrPage10)
	ON_EN_CHANGE(IDC_EDITWrPage11, OnChangeEDITWrPage11)
	ON_EN_CHANGE(IDC_EDITWrPage12, OnChangeEDITWrPage12)
	ON_EN_CHANGE(IDC_EDITWrPage13, OnChangeEDITWrPage13)
	ON_EN_CHANGE(IDC_EDITWrPage14, OnChangeEDITWrPage14)
	ON_EN_CHANGE(IDC_EDITWrPage15, OnChangeEDITWrPage15)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUltraLight message handlers

BOOL CUltraLight::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_brush.CreateSolidBrush(RGB(255, 0, 0));

	m_btnWritePage.SetThemeHelper(&m_ThemeHelper);
	m_bntRequst.SetThemeHelper(&m_ThemeHelper);
	m_btnReadPage.SetThemeHelper(&m_ThemeHelper);
	m_btnHalt.SetThemeHelper(&m_ThemeHelper);

	CString	String;

	for (int i = 0; i <= 15; i++) {
		String.Format(__T("%02d"), i);
		m_ctlReadPage.InsertString(i, String);
		m_ctlWritePage.InsertString(i, String);
	}
	m_ctlReadPage.SetCurSel(0);
	m_ctlWritePage.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

HBRUSH CUltraLight::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: Change any attributes of the DC here
	if (GetDlgItem(IDC_Edit_RdPage22)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_Edit_RdPage3)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_Edit_WrPage22)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_Edit_WrPage3)->m_hWnd == pWnd->m_hWnd) {
		pDC->SetBkColor(RGB(255, 0, 0));
		return m_brush;
	}
	
	// TODO: Return a different brush if the default is not desired
	return hbr;
}

void CUltraLight::OnBUTTONRequst() 
{
	// TODO: Add your control notification handler code here
	CString			String, tmpString;
	unsigned char	Mode;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetULMSG);
		UpdateData(false);
		return;
	}

	if (m_intULIdle == 0)
		Mode = 0x26;
	else
		Mode = 0x52;

	String = "";
	StrTmp.Format(">>Searching    Mode:%s\r\n", m_intULIdle ? "All" : "Idle");
	if ( (ret = API_MF_GET_SNR(g_hCOM, DeviceAddr, Mode, 0x00, Buffer)) != 0) {
		tmpString.Format("<<%s!\n", CShare::Return_CodeError(Buffer[0]));
		StrTmp += tmpString;
	}
	else {
		for (int i = 0; i < Buffer[0] - 1; i++) {
			tmpString.Format("%02X ", Buffer[2 + i]);
			String += tmpString;
		}
		StrTmp += "<<";
		StrTmp += String;
		StrTmp += "    Searching Success!";
	}

	CShare::WriteToResult(StrTmp, m_strRetULMSG);
	m_strULMSG = String;
	UpdateData(false);
}

void CUltraLight::OnBUTTONHalt() 
{
	// TODO: Add your control notification handler code here
	CString String;
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetULMSG);
		UpdateData(false);
		return;
	}

	StrTmp.Format(">>Halt\r\n");
	if ( (ret = API_MF_Halt(g_hCOM, DeviceAddr)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Halt Success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetULMSG);
	UpdateData(false);
}

void CUltraLight::OnBUTTONReadPage() 
{
	// TODO: Add your control notification handler code here
	CString	String, string;
	int		mPage;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetULMSG);
		UpdateData(false);
		return;
	}

	//GetDlgItemText(IDC_COMBOReadPage, StrTmp);
	//mPage = (int) strtol(StrTmp, NULL, 16);
	mPage = ((CComboBox*)GetDlgItem(IDC_COMBOReadPage))->GetCurSel();

	StrTmp.Format(">>Reading    Page:%02d\r\n", mPage);
	String = "";
	if ( (ret = API_MF_Read(g_hCOM, DeviceAddr, 0x00, mPage, 0x01, NULL, Buffer)) != 0) {
		string.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += string;
	}
	else {
		if (mPage != 2) {
			for (int i = 1; i <= Buffer[0]; i++) {
				string.Format("%02X ", Buffer[i]);
				String += string;
			}
		}

		string = "<<";
		string += String;
		string += "    Reading Success!";
		StrTmp += string;
		
		switch (mPage) {
		case 0:
			m_strRdPage0 = String;
			break;
		case 1:
			m_strRdPage1 = String;
			break;
		case 2:
			String.Format("%02X %02X", Buffer[1], Buffer[2]);
			m_strRdPage21 = String;
			String.Format("%02X %02X", Buffer[3], Buffer[4]);
			m_strRdPage22 = String;
			break;
		case 3:
			m_strRdPage3 = String;
			break;
		case 4:
			m_strRdPage4 = String;
			break;
		case 5:
			m_strRdPage5 = String;
			break;
		case 6:
			m_strRdPage6 = String;
			break;
		case 7:
			m_strRdPage7 = String;
			break;
		case 8:
			m_strRdPage8 = String;
			break;
		case 9:
			m_strRdPage9 = String;
			break;
		case 10:
			m_strRdPage10 = String;
			break;
		case 11:
			m_strRdPage11 = String;
			break;
		case 12:
			m_strRdPage12 = String;
			break;
		case 13:
			m_strRdPage13 = String;
			break;
		case 14:
			m_strRdPage14 = String;
			break;
		case 15:
			m_strRdPage15 = String;
			break;
		}
	}

	CShare::WriteToResult(StrTmp, m_strRetULMSG);
	UpdateData(false);
}

void CUltraLight::OnBUTTONWritePage() 
{
	// TODO: Add your control notification handler code here
	unsigned char	PageData[64];
	int				mPage, SizeStr = 0;
	CString			String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetULMSG);
		UpdateData(false);
		return;
	}

	//GetDlgItemText(IDC_COMBOWritePage, StrTmp);
	//mPage = (int) strtol(StrTmp, NULL, 16);
	mPage = ((CComboBox*)GetDlgItem(IDC_COMBOWritePage))->GetCurSel();

	switch (mPage) {
	case 0:
		if (m_strWrPage0.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage0);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 1:
		if (m_strWrPage1.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage1);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 2:
		if (m_strWrPage21.IsEmpty() || m_strWrPage22.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage21);
		SizeStr = CShare::OXStrtoD(PageData);
		strcpy( (char *)&PageData[2], m_strWrPage22);
		SizeStr += CShare::OXStrtoD(&PageData[2]);
		break;
	case 3:
		if (m_strWrPage3.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage3);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 4:
		if (m_strWrPage4.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage4);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 5:
		if (m_strWrPage5.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage5);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 6:
		if (m_strWrPage6.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage6);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 7:
		if (m_strWrPage7.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage7);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 8:
		if (m_strWrPage8.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage8);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 9:
		if (m_strWrPage9.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage9);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 10:
		if (m_strWrPage10.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage10);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 11:
		if (m_strWrPage11.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage11);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 12:
		if (m_strWrPage12.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage12);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 13:
		if (m_strWrPage13.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage13);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 14:
		if (m_strWrPage14.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage14);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	case 15:
		if (m_strWrPage15.IsEmpty()) {
			MessageBox("Please input data to be written!", "Warning", MB_OK | MB_ICONINFORMATION);
			return;
		}
		strcpy( (char *)PageData, m_strWrPage15);
		SizeStr = CShare::OXStrtoD(PageData);
		break;
	}

	if (SizeStr != 4) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	StrTmp.Format(">>Writing    Page:%02d Data:%02X %02X %02X %02X\r\n", mPage, PageData[0], PageData[1], PageData[2], PageData[3]);
	if ( (ret = API_MF_Write(g_hCOM, DeviceAddr, 0x00, mPage, 0x01, NULL, PageData, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String = "<<Writing Success!";
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetULMSG);
	UpdateData(false);
}

void CUltraLight::OnChangeEDITRdPage0() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage0);
	m_strRdPage0 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage1);
	m_strRdPage1 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEditRdPage21() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit_RdPage21);
	m_strRdPage21 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEditRdPage22() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit_RdPage22);
	m_strRdPage22 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEditRdPage3() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit_RdPage3);
	m_strRdPage3 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage4() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage4);
	m_strRdPage4 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage5() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage5);
	m_strRdPage5 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage6() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage6);
	m_strRdPage6 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage7() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage7);
	m_strRdPage7 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage8() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage8);
	m_strRdPage8 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage9() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage9);
	m_strRdPage9 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage10() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage10);
	m_strRdPage10 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage11() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage11);
	m_strRdPage11 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage12() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage12);
	m_strRdPage12 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage13() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage13);
	m_strRdPage13 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage14() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage14);
	m_strRdPage14 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITRdPage15() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdPage15);
	m_strRdPage15 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage0() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage0);
	m_strWrPage0 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage1);
	m_strWrPage1 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEditWrPage21() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit_WrPage21);
	m_strWrPage21 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEditWrPage22() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit_WrPage22);
	m_strWrPage22 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEditWrPage3() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit_WrPage3);
	m_strWrPage3 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage4() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage4);
	m_strWrPage4 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage5() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage5);
	m_strWrPage5 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage6() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage6);
	m_strWrPage6 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage7() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage7);
	m_strWrPage7 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage8() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage8);
	m_strWrPage8 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage9() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage9);
	m_strWrPage9 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage10() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage10);
	m_strWrPage10 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage11() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage11);
	m_strWrPage11 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage12() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage12);
	m_strWrPage12 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage13() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage13);
	m_strWrPage13 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage14() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage14);
	m_strWrPage14 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CUltraLight::OnChangeEDITWrPage15() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrPage15);
	m_strWrPage15 = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}
